<?php
	error_reporting(0);

	require_once "../../../admin/lib/composer.php";
	require_once "../../../admin/lib/minify.php";
	require_once "../../../admin/lib/common.php";
	require_once "../../../admin/lib/debug.php";
	require_once "../../../admin/lib/error/error.php";
	require_once "../../../admin/lib/include/file.php";
	require_once "../../../admin/lib/include/dir.php";



	$dir	= dirname(__FILE__);
	$conf	= CFile::GetJson("../../../upload/conf/assets.json");


	$minify = CMinify::newInstance()
		->setTypeCSS()
		->setMinify($conf["css"]["type"] == "prod")
		->setConcatenate($conf["css"]["type"] == "prod")
		->addFiles(			
			array(
				$dir . "/rtl.fonts.external.css",
			),
			"first"
		)
		->addFilesByPrefix(
			$dir , 
			"rtl.font." , 
			"css" 
		)
		->addFilesByPrefix(
			$dir , 
			"rtl.layout." , 
			"css" 
		)
		->addFilesByPrefix(
			$dir , 
			"rtl.global." , 
			"css" 
		)
		->addFilesByPrefix(
			$dir , 
			"rtl.plugin." , 
			"css" 
		)
		->addFilesByPrefix(
			$dir , 
			"rtl.module." , 
			"css" 
		)
		->addFilesByPrefix(
			$dir , 
			"rtl.widget." , 
			"css" 
		)
		->addFilesByPrefix(
			$dir , 
			"rtl.custom." , 
			"css" 
		)

		->setCacheFile("../../../upload/_cache/style-" . $conf["css"]["type"] . "-" . $conf["css"]["ver"] . "-rtl.css")
		->setVersion($conf["css"]["ver"])
		->setNoCache(!$conf["css"]["cache"])
		->output();
